/*
 * Decompiled with CFR 0.152.
 */
package org.cef.browser;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.nio.ByteBuffer;
import java.util.HashMap;
import net.montoyo.mcef.MCEF;
import net.montoyo.mcef.api.IBrowser;
import net.montoyo.mcef.api.IStringVisitor;
import net.montoyo.mcef.client.ClientProxy;
import net.montoyo.mcef.client.StringVisitor;
import net.montoyo.mcef.utilities.Log;
import org.cef.CefClient;
import org.cef.DummyComponent;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefBrowser_N;
import org.cef.browser.CefRenderer;
import org.cef.browser.CefRequestContext;
import org.cef.callback.CefDragData;
import org.cef.handler.CefRenderHandler;
import org.lwjgl.BufferUtils;

public class CefBrowserOsr
extends CefBrowser_N
implements CefRenderHandler,
IBrowser {
    private CefRenderer renderer_;
    private Rectangle browser_rect_ = new Rectangle(0, 0, 1, 1);
    private Point screenPoint_ = new Point(0, 0);
    private boolean isTransparent_;
    private final DummyComponent dc_ = new DummyComponent();
    private MouseEvent lastMouseEvent = new MouseEvent(this.dc_, 503, 0L, 0, 0, 0, 0, false);
    public static boolean CLEANUP = true;
    private final PaintData paintData = new PaintData();
    private static final HashMap<Integer, Character> WORST_HACK = new HashMap();

    CefBrowserOsr(CefClient client, String url, boolean transparent, CefRequestContext context) {
        this(client, url, transparent, context, null, null);
    }

    private CefBrowserOsr(CefClient client, String url, boolean transparent, CefRequestContext context, CefBrowserOsr parent, Point inspectAt) {
        super(client, url, context, parent, inspectAt);
        this.isTransparent_ = transparent;
        this.renderer_ = new CefRenderer(transparent);
    }

    @Override
    public void createImmediately() {
        this.createBrowserIfRequired(false);
    }

    @Override
    public Component getUIComponent() {
        return this.dc_;
    }

    @Override
    public CefRenderHandler getRenderHandler() {
        return this;
    }

    @Override
    protected CefBrowser_N createDevToolsBrowser(CefClient client, String url, CefRequestContext context, CefBrowser_N parent, Point inspectAt) {
        return new CefBrowserOsr(client, url, this.isTransparent_, context, this, inspectAt);
    }

    @Override
    public Rectangle getViewRect(CefBrowser browser) {
        return this.browser_rect_;
    }

    @Override
    public Point getScreenPoint(CefBrowser browser, Point viewPoint) {
        Point screenPoint = new Point(this.screenPoint_);
        screenPoint.translate(viewPoint.x, viewPoint.y);
        return screenPoint;
    }

    @Override
    public void onPopupShow(CefBrowser browser, boolean show) {
        if (!show) {
            this.renderer_.clearPopupRects();
            this.invalidate();
        }
    }

    @Override
    public void onPopupSize(CefBrowser browser, Rectangle size) {
        this.renderer_.onPopupSize(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPaint(CefBrowser browser, boolean popup, Rectangle[] dirtyRects, ByteBuffer buffer, int width, int height) {
        if (popup) {
            return;
        }
        int size = width * height << 2;
        PaintData paintData = this.paintData;
        synchronized (paintData) {
            if (buffer.limit() > size) {
                Log.warning("Skipping MCEF browser frame, data is too heavy", new Object[0]);
            } else {
                if (this.paintData.hasFrame) {
                    this.paintData.fullReRender = true;
                }
                if (this.paintData.buffer == null || size != this.paintData.buffer.capacity()) {
                    this.paintData.buffer = BufferUtils.createByteBuffer((int)size);
                }
                this.paintData.buffer.position(0);
                this.paintData.buffer.limit(buffer.limit());
                buffer.position(0);
                this.paintData.buffer.put(buffer);
                this.paintData.buffer.position(0);
                this.paintData.width = width;
                this.paintData.height = height;
                PaintData.access$602(this.paintData, dirtyRects);
                this.paintData.hasFrame = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mcefUpdate() {
        PaintData paintData = this.paintData;
        synchronized (paintData) {
            if (this.paintData.hasFrame) {
                this.renderer_.onPaint(false, this.paintData.dirtyRects, this.paintData.buffer, this.paintData.width, this.paintData.height, this.paintData.fullReRender);
                this.paintData.hasFrame = false;
                this.paintData.fullReRender = false;
            }
        }
        this.sendMouseEvent(this.lastMouseEvent);
    }

    @Override
    public void onCursorChange(CefBrowser browser, int cursorType) {
    }

    @Override
    public boolean startDragging(CefBrowser browser, CefDragData dragData, int mask, int x, int y) {
        return false;
    }

    @Override
    public void updateDragCursor(CefBrowser browser, int operation) {
    }

    private void createBrowserIfRequired(boolean hasParent) {
        if (this.getNativeRef("CefBrowser") == 0L) {
            if (this.getParentBrowser() != null) {
                this.createDevTools(this.getParentBrowser(), this.getClient(), 0L, true, this.isTransparent_, null, this.getInspectAt());
            } else {
                this.createBrowser(this.getClient(), 0L, this.getUrl(), true, this.isTransparent_, null, this.getRequestContext());
            }
        } else {
            this.setFocus(true);
        }
    }

    @Override
    public void close() {
        if (CLEANUP) {
            ((ClientProxy)MCEF.PROXY).removeBrowser(this);
            this.renderer_.cleanup();
        }
        super.close(true);
    }

    @Override
    public void resize(int width, int height) {
        this.browser_rect_.setBounds(0, 0, width, height);
        this.dc_.setBounds(this.browser_rect_);
        this.dc_.setVisible(true);
        this.wasResized(width, height);
    }

    @Override
    public void draw(double x1, double y1, double x2, double y2) {
        this.renderer_.render(x1, y1, x2, y2);
    }

    @Override
    public int getTextureID() {
        return this.renderer_.texture_id_[0];
    }

    @Override
    public void injectMouseMove(int x, int y, int mods, boolean left) {
        MouseEvent ev;
        this.lastMouseEvent = ev = new MouseEvent(this.dc_, 503, 0L, mods, x, y, 0, false);
        this.sendMouseEvent(ev);
    }

    @Override
    public void injectMouseButton(int x, int y, int mods, int btn, boolean pressed, int ccnt) {
        MouseEvent ev = new MouseEvent(this.dc_, pressed ? 501 : 502, 0L, mods, x, y, ccnt, false, btn);
        this.sendMouseEvent(ev);
    }

    @Override
    public void injectKeyTyped(char c, int mods) {
        KeyEvent ev = new KeyEvent(this.dc_, 400, 0L, mods, 0, c);
        this.sendKeyEvent(ev);
    }

    public static int remapKeycode(int kc, char c) {
        switch (kc) {
            case 14: {
                return 8;
            }
            case 211: {
                return 46;
            }
            case 208: {
                return 40;
            }
            case 28: {
                return 13;
            }
            case 1: {
                return 27;
            }
            case 203: {
                return 37;
            }
            case 205: {
                return 39;
            }
            case 15: {
                return 9;
            }
            case 200: {
                return 38;
            }
            case 201: {
                return 33;
            }
            case 209: {
                return 34;
            }
            case 207: {
                return 35;
            }
            case 199: {
                return 36;
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void injectKeyPressedByKeyCode(int keyCode, char c, int mods) {
        if (c != '\u0000') {
            HashMap<Integer, Character> hashMap = WORST_HACK;
            synchronized (hashMap) {
                WORST_HACK.put(keyCode, Character.valueOf(c));
            }
        }
        KeyEvent ev = new KeyEvent(this.dc_, 401, 0L, mods, CefBrowserOsr.remapKeycode(keyCode, c), c);
        this.sendKeyEvent(ev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void injectKeyReleasedByKeyCode(int keyCode, char c, int mods) {
        if (c == '\u0000') {
            HashMap<Integer, Character> hashMap = WORST_HACK;
            synchronized (hashMap) {
                c = WORST_HACK.getOrDefault(keyCode, Character.valueOf('\u0000')).charValue();
            }
        }
        KeyEvent ev = new KeyEvent(this.dc_, 402, 0L, mods, CefBrowserOsr.remapKeycode(keyCode, c), c);
        this.sendKeyEvent(ev);
    }

    @Override
    public void injectMouseWheel(int x, int y, int mods, int amount, int rot) {
        MouseWheelEvent ev = new MouseWheelEvent((Component)this.dc_, 507, 0L, mods, x, y, 0, false, 0, amount, rot);
        this.sendMouseWheelEvent(ev);
    }

    @Override
    public void runJS(String script, String frame) {
        this.executeJavaScript(script, frame, 0);
    }

    @Override
    public void visitSource(IStringVisitor isv) {
        this.getSource(new StringVisitor(isv));
    }

    @Override
    public boolean isPageLoading() {
        return this.isLoading();
    }

    private static class PaintData {
        private ByteBuffer buffer;
        private int width;
        private int height;
        private Rectangle[] dirtyRects;
        private boolean hasFrame;
        private boolean fullReRender;

        private PaintData() {
        }

        static /* synthetic */ Rectangle[] access$602(PaintData x0, Rectangle[] x1) {
            x0.dirtyRects = x1;
            return x1;
        }
    }
}

